#pragma once

#include "threadpool.h"
//#include <Windows.h>

Threadpool* Threadpool::instance = NULL;

/**********************************************************************
* Constructor (private)
**********************************************************************/
Threadpool::Threadpool() {
	for (unsigned int i = 0; i < std::thread::hardware_concurrency(); ++i) threads.push_back({ std::thread(&Threadpool::Thread, this, i), true, false });
}

/**********************************************************************
* Destructor
**********************************************************************/
Threadpool::~Threadpool() {
	{
		std::lock_guard<std::mutex> mlock(main_mutex);
		for (auto& thread : threads) thread.stop = true;
	}

	main_cond.notify_all();
	for (auto& thread : threads) thread.thread.join();
}

/**********************************************************************
* Thread
**********************************************************************/
void Threadpool::Thread(const int i) {
	std::function<void()> function;

	while (true) {
		{
			std::unique_lock<std::mutex> mlock(main_mutex);
			main_cond.wait(mlock, [&] { return queue.size() || threads[i].stop; });
			if (queue.size()) {
				threads[i].free = false;
				function = queue.front();
				queue.pop_front();
			} else {
				return;
			}
		}
//		if (threads[i].stop) break;

		function();

		{
			std::lock_guard<std::mutex> mlock(return_mutex); // necessary
			threads[i].free = true;
		}
		return_cond.notify_all();
	}
}

/**********************************************************************
* Wait
**********************************************************************/
void Threadpool::Wait() {
	if (!queue.size()) {
		int i;
		for (i = 0; i < (int)threads.size(); ++i) {
			if (!threads[i].free) break;
		}
		if (i == threads.size()) return;
	}

	{
		std::unique_lock<std::mutex> rlock(return_mutex);
		return_cond.wait(rlock, [&]{
			if (queue.size()) return false;
			for (auto& thread : threads) {
				if (!thread.free) return false;
			}
			return true;
		});
	}
}

/**********************************************************************
* Queue
**********************************************************************/
void Threadpool::Queue(std::function<void()> function) {
	std::lock_guard<std::mutex> mlock(main_mutex); // not sure what this is for
	queue.push_back(std::move(function));
	main_cond.notify_one(); // changed from notify_all()
}
