#pragma once

#include <thread>
#include <mutex>
#include <condition_variable>
#include <functional>
#include <deque>
#include <vector>

class Threadpool {
public:
	static Threadpool* GetInstance() { if (!instance) instance = new Threadpool(); return instance; } // removed number of threads
	void Queue(std::function<void()> function);
	int GetNThreads() { return (int)threads.size(); };
	void Wait();

private:
	static Threadpool* instance;
	Threadpool(); // constructor is private
	~Threadpool();
	void Thread(int i);
	struct ThreadStruct {
		std::thread thread;
		bool free;
		bool stop;
	};
	std::vector<ThreadStruct> threads;
	std::deque<std::function<void()>> queue;
	std::mutex main_mutex;
	std::mutex return_mutex;
	std::condition_variable main_cond;
	std::condition_variable return_cond;
};
